#include "gfx/legato/generated/screen/le_gen_screen_Screen1.h"

#include <p32xxxx.h>    //ys added          //WX^ȂǈĂ̈    //LATDbits.LATD0 = 1; 
#include "lcd_ACM1602_lib_i2c.h"

#include "definitions.h"    //K{ ys added //ꂪȂƁ@SYS_TIME_CallbackRegisterMS()RpCG[

// screen member widget declarations
leWidget* root0;

leWidget* Screen1_PanelWidget0;
leImageWidget* Screen1_Bulb_On_Image1;
leImageWidget* Screen1_Bulb_On_Image2;
leImageWidget* Screen1_Bulb_On_Image3;
leImageWidget* Screen1_Bulb_On_Image4;
leImageWidget* Screen1_Bulb_Off_Image1;
leImageWidget* Screen1_Bulb_Off_Image2;
leImageWidget* Screen1_Bulb_Off_Image3;
leImageWidget* Screen1_Bulb_Off_Image4;
leLabelWidget* Screen1_LED_Touch_ControlLabel;
leButtonWidget* Screen1_LED_OnOff_Btn;
leButtonWidget* Screen1_Back_Btn;
leButtonWidget* Screen1_Next_Btn;

static leBool initialized = LE_FALSE;
static leBool showing = LE_FALSE;

int Led_Mode;
int ChangeNG;


extern int Mode1;
extern int ScreenNum;
extern SYS_TIME_HANDLE StringChange_handle;
extern bool WideUseMojuleBoard;    //ėpW[]{[hڑĂꍇF1

SYS_TIME_HANDLE PictureCycle_handle;
int OneShotFlag_Scr1NextBtn;




leResult screenInit_Screen1(void)
{
    if(initialized == LE_TRUE)
        return LE_FAILURE;

    initialized = LE_TRUE;

    return LE_SUCCESS;
}

leResult screenShow_Screen1(void)
{
    if(showing == LE_TRUE)
        return LE_FAILURE;

    // layer 0
    root0 = leWidget_New();
    root0->fn->setSize(root0, 800, 480);
    root0->fn->setBackgroundType(root0, LE_WIDGET_BACKGROUND_NONE);
    root0->fn->setMargins(root0, 0, 0, 0, 0);
    root0->flags |= LE_WIDGET_IGNOREEVENTS;
    root0->flags |= LE_WIDGET_IGNOREPICK;

    Screen1_PanelWidget0 = leWidget_New();
    Screen1_PanelWidget0->fn->setPosition(Screen1_PanelWidget0, 2, 0);
    Screen1_PanelWidget0->fn->setSize(Screen1_PanelWidget0, 800, 480);
    Screen1_PanelWidget0->fn->setScheme(Screen1_PanelWidget0, &BaseBlue_TextYellow);
    root0->fn->addChild(root0, (leWidget*)Screen1_PanelWidget0);

    Screen1_Bulb_On_Image1 = leImageWidget_New();
    Screen1_Bulb_On_Image1->fn->setPosition(Screen1_Bulb_On_Image1, 90, 40);
    Screen1_Bulb_On_Image1->fn->setSize(Screen1_Bulb_On_Image1, 120, 44);
    Screen1_Bulb_On_Image1->fn->setBorderType(Screen1_Bulb_On_Image1, LE_WIDGET_BORDER_NONE);
    Screen1_Bulb_On_Image1->fn->setImage(Screen1_Bulb_On_Image1, (leImage*)&bulb_on);
    root0->fn->addChild(root0, (leWidget*)Screen1_Bulb_On_Image1);

    Screen1_Bulb_On_Image2 = leImageWidget_New();
    Screen1_Bulb_On_Image2->fn->setPosition(Screen1_Bulb_On_Image2, 90, 100);
    Screen1_Bulb_On_Image2->fn->setSize(Screen1_Bulb_On_Image2, 120, 44);
    Screen1_Bulb_On_Image2->fn->setBorderType(Screen1_Bulb_On_Image2, LE_WIDGET_BORDER_NONE);
    Screen1_Bulb_On_Image2->fn->setImage(Screen1_Bulb_On_Image2, (leImage*)&bulb_on);
    root0->fn->addChild(root0, (leWidget*)Screen1_Bulb_On_Image2);

    Screen1_Bulb_On_Image3 = leImageWidget_New();
    Screen1_Bulb_On_Image3->fn->setPosition(Screen1_Bulb_On_Image3, 90, 160);
    Screen1_Bulb_On_Image3->fn->setSize(Screen1_Bulb_On_Image3, 120, 44);
    Screen1_Bulb_On_Image3->fn->setBorderType(Screen1_Bulb_On_Image3, LE_WIDGET_BORDER_NONE);
    Screen1_Bulb_On_Image3->fn->setImage(Screen1_Bulb_On_Image3, (leImage*)&bulb_on);
    root0->fn->addChild(root0, (leWidget*)Screen1_Bulb_On_Image3);

    Screen1_Bulb_On_Image4 = leImageWidget_New();
    Screen1_Bulb_On_Image4->fn->setPosition(Screen1_Bulb_On_Image4, 90, 220);
    Screen1_Bulb_On_Image4->fn->setSize(Screen1_Bulb_On_Image4, 120, 44);
    Screen1_Bulb_On_Image4->fn->setBorderType(Screen1_Bulb_On_Image4, LE_WIDGET_BORDER_NONE);
    Screen1_Bulb_On_Image4->fn->setImage(Screen1_Bulb_On_Image4, (leImage*)&bulb_on);
    root0->fn->addChild(root0, (leWidget*)Screen1_Bulb_On_Image4);

    Screen1_Bulb_Off_Image1 = leImageWidget_New();
    Screen1_Bulb_Off_Image1->fn->setPosition(Screen1_Bulb_Off_Image1, 590, 40);
    Screen1_Bulb_Off_Image1->fn->setSize(Screen1_Bulb_Off_Image1, 120, 44);
    Screen1_Bulb_Off_Image1->fn->setBorderType(Screen1_Bulb_Off_Image1, LE_WIDGET_BORDER_NONE);
    Screen1_Bulb_Off_Image1->fn->setImage(Screen1_Bulb_Off_Image1, (leImage*)&bulb_off);
    root0->fn->addChild(root0, (leWidget*)Screen1_Bulb_Off_Image1);

    Screen1_Bulb_Off_Image2 = leImageWidget_New();
    Screen1_Bulb_Off_Image2->fn->setPosition(Screen1_Bulb_Off_Image2, 590, 100);
    Screen1_Bulb_Off_Image2->fn->setSize(Screen1_Bulb_Off_Image2, 120, 44);
    Screen1_Bulb_Off_Image2->fn->setBorderType(Screen1_Bulb_Off_Image2, LE_WIDGET_BORDER_NONE);
    Screen1_Bulb_Off_Image2->fn->setImage(Screen1_Bulb_Off_Image2, (leImage*)&bulb_off);
    root0->fn->addChild(root0, (leWidget*)Screen1_Bulb_Off_Image2);

    Screen1_Bulb_Off_Image3 = leImageWidget_New();
    Screen1_Bulb_Off_Image3->fn->setPosition(Screen1_Bulb_Off_Image3, 590, 160);
    Screen1_Bulb_Off_Image3->fn->setSize(Screen1_Bulb_Off_Image3, 120, 44);
    Screen1_Bulb_Off_Image3->fn->setBorderType(Screen1_Bulb_Off_Image3, LE_WIDGET_BORDER_NONE);
    Screen1_Bulb_Off_Image3->fn->setImage(Screen1_Bulb_Off_Image3, (leImage*)&bulb_off);
    root0->fn->addChild(root0, (leWidget*)Screen1_Bulb_Off_Image3);

    Screen1_Bulb_Off_Image4 = leImageWidget_New();
    Screen1_Bulb_Off_Image4->fn->setPosition(Screen1_Bulb_Off_Image4, 590, 220);
    Screen1_Bulb_Off_Image4->fn->setSize(Screen1_Bulb_Off_Image4, 120, 44);
    Screen1_Bulb_Off_Image4->fn->setBorderType(Screen1_Bulb_Off_Image4, LE_WIDGET_BORDER_NONE);
    Screen1_Bulb_Off_Image4->fn->setImage(Screen1_Bulb_Off_Image4, (leImage*)&bulb_off);
    root0->fn->addChild(root0, (leWidget*)Screen1_Bulb_Off_Image4);

    Screen1_LED_Touch_ControlLabel = leLabelWidget_New();
    Screen1_LED_Touch_ControlLabel->fn->setPosition(Screen1_LED_Touch_ControlLabel, 270, 240);
    Screen1_LED_Touch_ControlLabel->fn->setSize(Screen1_LED_Touch_ControlLabel, 260, 48);
    Screen1_LED_Touch_ControlLabel->fn->setScheme(Screen1_LED_Touch_ControlLabel, &BaseBlue_TextYellow);
    Screen1_LED_Touch_ControlLabel->fn->setHAlignment(Screen1_LED_Touch_ControlLabel, LE_HALIGN_CENTER);
    Screen1_LED_Touch_ControlLabel->fn->setString(Screen1_LED_Touch_ControlLabel, (leString*)&string_LED_Touch_Control);
    root0->fn->addChild(root0, (leWidget*)Screen1_LED_Touch_ControlLabel);

    Screen1_LED_OnOff_Btn = leButtonWidget_New();
    Screen1_LED_OnOff_Btn->fn->setPosition(Screen1_LED_OnOff_Btn, 335, 290);
    Screen1_LED_OnOff_Btn->fn->setSize(Screen1_LED_OnOff_Btn, 130, 55);
    Screen1_LED_OnOff_Btn->fn->setScheme(Screen1_LED_OnOff_Btn, &BaseYellow_TextBlue);
    Screen1_LED_OnOff_Btn->fn->setString(Screen1_LED_OnOff_Btn, (leString*)&string_On_Off);
    Screen1_LED_OnOff_Btn->fn->setPressedEventCallback(Screen1_LED_OnOff_Btn, event_Screen1_LED_OnOff_Btn_OnPressed);
    root0->fn->addChild(root0, (leWidget*)Screen1_LED_OnOff_Btn);
    Screen1_Bulb_On_Image1->fn->setVisible(Screen1_Bulb_On_Image1, LE_FALSE);      //Bulb_On_Image1ouON摜F\
    Screen1_Bulb_On_Image2->fn->setVisible(Screen1_Bulb_On_Image2, LE_FALSE);      //Bulb_On_Image2ouON摜F\
    Screen1_Bulb_On_Image3->fn->setVisible(Screen1_Bulb_On_Image3, LE_FALSE);      //Bulb_On_Image3ouON摜F\
    Screen1_Bulb_On_Image4->fn->setVisible(Screen1_Bulb_On_Image4, LE_FALSE);      //Bulb_On_Image4ouON摜F\

    Screen1_Back_Btn = leButtonWidget_New();
    Screen1_Back_Btn->fn->setPosition(Screen1_Back_Btn, 50, 410);
    Screen1_Back_Btn->fn->setSize(Screen1_Back_Btn, 140, 40);
    Screen1_Back_Btn->fn->setScheme(Screen1_Back_Btn, &BaseYellow_TextBlue);
    Screen1_Back_Btn->fn->setString(Screen1_Back_Btn, (leString*)&string_BACK);
    Screen1_Back_Btn->fn->setPressedEventCallback(Screen1_Back_Btn, event_Screen1_Back_Btn_OnPressed);
    root0->fn->addChild(root0, (leWidget*)Screen1_Back_Btn);

    Screen1_Next_Btn = leButtonWidget_New();
    Screen1_Next_Btn->fn->setPosition(Screen1_Next_Btn, 610, 410);
    Screen1_Next_Btn->fn->setSize(Screen1_Next_Btn, 140, 40);
    Screen1_Next_Btn->fn->setScheme(Screen1_Next_Btn, &BaseYellow_TextBlue);
    Screen1_Next_Btn->fn->setString(Screen1_Next_Btn, (leString*)&string_NEXT);
    Screen1_Next_Btn->fn->setPressedEventCallback(Screen1_Next_Btn, event_Screen1_Next_Btn_OnPressed);
    root0->fn->addChild(root0, (leWidget*)Screen1_Next_Btn);

    leAddRootWidget(root0, 0);
    leSetLayerColorMode(0, LE_COLOR_MODE_RGB_565);

    showing = LE_TRUE;

    return LE_SUCCESS;
}




void TimerCallback_PictureCycle( uintptr_t context)
{
      
    ScreenNum++;
    if(ScreenNum == 6)ScreenNum = 2;
    switch(ScreenNum)
    {
        case 2:         //ubNXN[
                legato_showScreen(screenID_Screen2);
                if(WideUseMojuleBoard == true)  //ėpW[]{[hiiς݃{[h)̐ڑL
                {
                    lcd_ACM1602_cmd_i2c(0x80);  //1sڂ̐擪
                    lcd_ACM1602_str_i2c("                  ");
                    lcd_ACM1602_cmd_i2c(0xC0);  //2sڂ̐擪
                    lcd_ACM1602_str_i2c("                  ");
                } 
                LATGbits.LATG15 = 1;    //LED1_
                LATDbits.LATD4 = 0;
                LATAbits.LATA15 = 0;
                LATAbits.LATA14 = 0;
                break;
        case 3:         //~AXN[
                legato_showScreen(screenID_Screen3);
                if(WideUseMojuleBoard == true)  //ėpW[]{[hiiς݃{[h)̐ڑL
                {
                    lcd_ACM1602_cmd_i2c(0x80);  //1sڂ̐擪
                    lcd_ACM1602_str_i2c("Circles           ");
                    lcd_ACM1602_cmd_i2c(0xC0);  //2sڂ̐擪
                    lcd_ACM1602_str_i2c("                  ");
                }
                LATGbits.LATG15 = 0;
                LATDbits.LATD4 = 1;     //LED2_
                LATAbits.LATA15 = 0;
                LATAbits.LATA14 = 0;
                break;
        case 4:         //~A@XN[
                legato_showScreen(screenID_Screen4);
                if(WideUseMojuleBoard == true)  //ėpW[]{[hiiς݃{[h)̐ڑL
                {
                    lcd_ACM1602_cmd_i2c(0x80);  //1sڂ̐擪
                    lcd_ACM1602_str_i2c("Circles & Lines      ");
                    lcd_ACM1602_cmd_i2c(0xC0);  //2sڂ̐擪
                    lcd_ACM1602_str_i2c("                     ");
                }
                LATGbits.LATG15 = 0;
                LATDbits.LATD4 = 0;
                LATAbits.LATA15 = 1;        //LED3_
                LATAbits.LATA14 = 0;
                break;
        case 5:         //~AA`@XN[
                legato_showScreen(screenID_Screen5);
                if(WideUseMojuleBoard == true)  //ėpW[]{[hiiς݃{[h)̐ڑL
                {
                    lcd_ACM1602_cmd_i2c(0x80);  //1sڂ̐擪
                    lcd_ACM1602_str_i2c("Circles & Lines     ");
                    lcd_ACM1602_cmd_i2c(0xC0);  //2sڂ̐擪
                    lcd_ACM1602_str_i2c("& Rectangles        ");
                }
                LATGbits.LATG15 = 0;
                LATDbits.LATD4 = 0;
                LATAbits.LATA15 = 0;
                LATAbits.LATA14 = 1;        //LED4_
                break;
        default:
            break;
    }
    
  
}



void LedFunc(void)
{
    if(Led_Mode == 0)
    {
        Led_Mode = 1;
        LATGbits.LATG15 = 1;     //LED1_      //RG15(1)
        LATDbits.LATD4 = 1;    //LED2      //RD4(81)
        LATAbits.LATA15 = 1;    //LED3      //RA15(67)
        LATAbits.LATA14 = 1;    //LED4      //RA(66)
         
        Screen1_Bulb_Off_Image1->fn->setVisible(Screen1_Bulb_Off_Image1, LE_FALSE);   //Bulb_Off_Image1ouOFF摜F@\
        Screen1_Bulb_Off_Image2->fn->setVisible(Screen1_Bulb_Off_Image2, LE_FALSE);   //Bulb_Off_Image2ouOFF摜F@\
        Screen1_Bulb_Off_Image3->fn->setVisible(Screen1_Bulb_Off_Image3, LE_FALSE);   //Bulb_Off_Image3ouOFF摜F@\
        Screen1_Bulb_Off_Image4->fn->setVisible(Screen1_Bulb_Off_Image4, LE_FALSE);   //Bulb_Off_Image4ouOFF摜F@\
        
        
        
        Screen1_Bulb_On_Image1->fn->setVisible(Screen1_Bulb_On_Image1, LE_TRUE);      //Bulb_On_Image1ouON摜F@\
        Screen1_Bulb_On_Image2->fn->setVisible(Screen1_Bulb_On_Image2, LE_TRUE);      //Bulb_On_Image2ouON摜F@\
        Screen1_Bulb_On_Image3->fn->setVisible(Screen1_Bulb_On_Image3, LE_TRUE);      //Bulb_On_Image3ouON摜F@\
        Screen1_Bulb_On_Image4->fn->setVisible(Screen1_Bulb_On_Image4, LE_TRUE);      //Bulb_On_Image4ouON摜F@\
        
        if(WideUseMojuleBoard == true)  //ėpW[]{[hiiς݃{[h)̐ڑL
        {  
            lcd_ACM1602_cmd_i2c(0x80);  //1sڂ̐擪
            lcd_ACM1602_str_i2c("LED TouchControl  ");
            lcd_ACM1602_cmd_i2c(0xC0);  //2sڂ̐擪
            lcd_ACM1602_str_i2c("    LED: ON      ");
        }
        
    }
    else
    {
        Led_Mode = 0;
        LATGbits.LATG15 = 0;     //LED1
        LATDbits.LATD4 = 0;    //LED2
        LATAbits.LATA15 = 0;    //LED3
        LATAbits.LATA14 = 0;    //LED4
        
        Screen1_Bulb_Off_Image1->fn->setVisible(Screen1_Bulb_Off_Image1, LE_TRUE);   //Bulb_Off_Image1ouOFF摜F@\
        Screen1_Bulb_Off_Image2->fn->setVisible(Screen1_Bulb_Off_Image2, LE_TRUE);   //Bulb_Off_Image2ouOFF摜F@\
        Screen1_Bulb_Off_Image3->fn->setVisible(Screen1_Bulb_Off_Image3, LE_TRUE);   //Bulb_Off_Image3ouOFF摜F@\
        Screen1_Bulb_Off_Image4->fn->setVisible(Screen1_Bulb_Off_Image4, LE_TRUE);   //Bulb_Off_Image4ouOFF摜F@\
        
        Screen1_Bulb_On_Image1->fn->setVisible(Screen1_Bulb_On_Image1, LE_FALSE);      //Bulb_On_Image1ouON摜F\
        Screen1_Bulb_On_Image2->fn->setVisible(Screen1_Bulb_On_Image2, LE_FALSE);      //Bulb_On_Image2ouON摜F\
        Screen1_Bulb_On_Image3->fn->setVisible(Screen1_Bulb_On_Image3, LE_FALSE);      //Bulb_On_Image3ouON摜F\
        Screen1_Bulb_On_Image4->fn->setVisible(Screen1_Bulb_On_Image4, LE_FALSE);      //Bulb_On_Image4ouON摜F\
        
        if(WideUseMojuleBoard == true)  //ėpW[]{[hiiς݃{[h)̐ڑL
        {  
            lcd_ACM1602_cmd_i2c(0x80);  //1sڂ̐擪
            lcd_ACM1602_str_i2c("LED TouchControl    ");
            lcd_ACM1602_cmd_i2c(0xC0);  //2sڂ̐擪
            lcd_ACM1602_str_i2c("    LED: OFF      ");
        }
    }
    
}

//Vbg^C}@R[obN֐
void TimerCallback_LedBtn ( uintptr_t context )    //{^듮h~A500msecVbg^C} 
{
    ChangeNG = 0;   //500mseco߂̂ŁALED On/Off䋖
}



void event_Screen1_LED_OnOff_Btn_OnPressed(leButtonWidget* btn)
{
    if(ChangeNG == 0)   //LED On/Off ̏ꍇ  //`^Oh~
    {
        LedFunc();  //LEDF ON/OFF
        ChangeNG = 1;   //LED on/Off s
        SYS_TIME_CallbackRegisterMS(TimerCallback_LedBtn, 0, 500, SYS_TIME_SINGLE );    //500msecx
    }
}

void event_Screen1_Back_Btn_OnPressed(leButtonWidget* btn)
{
    legato_showScreen(screenID_Screen0);                    //screen0
    Mode1 = 1;
    SYS_TIME_TimerStart(StringChange_handle);
     All_LedOff();  //SLED
}


void TimerCallback_Scr1NextBtn ( uintptr_t context )    //{^듮h~Vbg^C} 
{
    OneShotFlag_Scr1NextBtn = 0;
}

void event_Screen1_Next_Btn_OnPressed(leButtonWidget* btn)
{  
    //    //Screen2i}`X^[gʁj^b`o듮h~
    OneShotFlag_Scr1NextBtn = 1;
    
    SYS_TIME_CallbackRegisterMS(TimerCallback_Scr1NextBtn, 0, 1000, SYS_TIME_SINGLE );
    
    ScreenNum = 2;
    legato_showScreen(screenID_Screen2);
    
     //}`TCN^C}X^[g    //Screen2i}`X^[gʁj
    PictureCycle_handle = SYS_TIME_CallbackRegisterMS(TimerCallback_PictureCycle, 0, 3000, SYS_TIME_PERIODIC );
  
    Led_Mode = 0;
    All_LedOff();   //SLED
     LATGbits.LATG15 = 1;     //LED1_      //RG15(1)
    
    if(WideUseMojuleBoard == true)  //ėpW[]{[hiiς݃{[h)̐ڑL
    {
        lcd_ACM1602_cmd_i2c(0x80);  //1sڂ̐擪
        lcd_ACM1602_str_i2c("                  ");
        lcd_ACM1602_cmd_i2c(0xC0);  //2sڂ̐擪
        lcd_ACM1602_str_i2c("                  ");
    }
}



void screenUpdate_Screen1(void)
{
}

void screenHide_Screen1(void)
{

    leRemoveRootWidget(root0, 0);
    leWidget_Delete(root0);
    root0 = NULL;

    Screen1_PanelWidget0 = NULL;
    Screen1_Bulb_On_Image1 = NULL;
    Screen1_Bulb_On_Image2 = NULL;
    Screen1_Bulb_On_Image3 = NULL;
    Screen1_Bulb_On_Image4 = NULL;
    Screen1_Bulb_Off_Image1 = NULL;
    Screen1_Bulb_Off_Image2 = NULL;
    Screen1_Bulb_Off_Image3 = NULL;
    Screen1_Bulb_Off_Image4 = NULL;
    Screen1_LED_Touch_ControlLabel = NULL;
    Screen1_LED_OnOff_Btn = NULL;
    Screen1_Back_Btn = NULL;
    Screen1_Next_Btn = NULL;


    showing = LE_FALSE;
}

void screenDestroy_Screen1(void)
{
    if(initialized == LE_FALSE)
        return;

    initialized = LE_FALSE;
}

leWidget* screenGetRoot_Screen1(uint32_t lyrIdx)
{
    if(lyrIdx >= LE_LAYER_COUNT)
        return NULL;

    switch(lyrIdx)
    {
        case 0:
        {
            return root0;
        }
        default:
        {
            return NULL;
        }
    }
}

